<?php

use App\Http\Controllers\Api\V1\AlasanJurusanController;
use App\Http\Controllers\Api\V1\ArticleController;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\BannerController;
use App\Http\Controllers\Api\V1\EkstrakurikulerController;
use App\Http\Controllers\Api\V1\CategoryController;
use App\Http\Controllers\Api\V1\FaqJurusanController;
use App\Http\Controllers\Api\V1\FasilitasController;
use App\Http\Controllers\Api\V1\GalleryController;
use App\Http\Controllers\Api\V1\InformasiSekolahController;
use App\Http\Controllers\Api\V1\KelasController;
use App\Http\Controllers\Api\V1\GuruController;
use App\Http\Controllers\Api\V1\GuruProduktifController;
use App\Http\Controllers\Api\V1\MapelController;
use App\Http\Controllers\Api\V1\SiswaController;
use App\Http\Controllers\Api\V1\TahunAjaranController;
use App\Http\Controllers\Api\V1\JurusanController;
use App\Http\Controllers\Api\V1\KeunggulanController;
use App\Http\Controllers\Api\V1\SambutanController;
use App\Http\Controllers\Api\V1\SejarahController;
use App\Http\Controllers\Api\V1\TingkatanController;
use App\Http\Controllers\Api\V1\WaliKelasController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::prefix('v1')->group(function(){
    // Auth
    Route::prefix('auth')->group(function(){
        Route::post('/login', [AuthController::class, 'login'])->name('auth.login');
        Route::middleware(['auth:sanctum'])->group(function () {
            Route::get('/profile', [AuthController::class, 'profile'])->name('auth.profile');
            Route::post('/logout', [AuthController::class, 'logout'])->name('auth.logout');
        });
    });

    Route::middleware(['auth:sanctum'])->group(function (){
        // Tahun Ajaran Endpoint
        Route::prefix('tahun-ajaran')->group(function(){
            Route::get('/', [TahunAjaranController::class, 'index'])->name('tahun-ajaran.get');
            Route::get('/active', [TahunAjaranController::class, 'getActiveTahunAjaran'])->name('tahun-ajaran.getActive');
        });
        // Mapel Endpoint
        Route::prefix('mapel')->group(function(){
            Route::get('/', [MapelController::class, 'index'])->name('mapel.get');
            Route::get('/detail', [MapelController::class, 'getDetail'])->name('mapel.getDetail');
        });
        // Kelas Endpoint
        Route::prefix('kelas')->group(function(){
            Route::get('/', [KelasController::class, 'index'])->name('mapel.get');
            Route::get('/detail', [KelasController::class, 'getDetailKelas'])->name('kelas.getDetail');
        });
        // Jurusan Endpoint
        Route::prefix('jurusan')->group(function (){
            Route::get('/',[JurusanController::class,'index'])->name('jurusan.get');
            Route::get('/detail',[JurusanController::class,'getDetail'])->name('jurusan.getDetail');
            Route::get('/slug',[JurusanController::class,'getJurusanBySlug'])->name('jurusan.getSlug');
            Route::get('/faq',[FaqJurusanController::class,'index'])->name('faqjurusan.get');
            Route::get('/alasan',[AlasanJurusanController::class,'index'])->name('alasanjurusan.get');
            Route::get('/guru-produktif',[GuruProduktifController::class,'index'])->name('guru-produktif.get');
        });
        // Tingkatan Endpoint
        Route::prefix('tingkatan')->group(function () {
            Route::get('/', [TingkatanController::class, 'index'])->name('tingkatan.get');
            Route::get('/detail', [TingkatanController::class, 'getDetail'])->name('tingkatan.getDetail');
        });
        // Guru Endpoint
        Route::prefix('guru')->group(function () {
            Route::get('/', [GuruController::class, 'index'])->name('guru.get');
            Route::get('/detail', [GuruController::class, 'getDetail'])->name('guru.getDetail');
        });
        // Siswa Endpoint
        Route::prefix('siswa')->group(function () {
            Route::get('/', [SiswaController::class, 'index'])->name('siswa.get');
            Route::get('/detail', [SiswaController::class, 'getDetail'])->name('siswa.getDetail');
        });
        // Wali Kelas Endpoint
        Route::prefix('wali-kelas')->group(function(){
            Route::get('/', [WaliKelasController::class, 'index'])->name('wali_kelas.get');
            Route::get('/detail', [WaliKelasController::class, 'getDetail'])->name('wali_kelas.getDetail');
        });
        //Ekstrakurikuler Endpoint
        Route::prefix('ekstrakurikuler')->group(function(){
            Route::get('/', [EkstrakurikulerController::class, 'index'])->name('ekstrakurikuler.get');
        });
        // Article Endpoint
        Route::prefix('articles')->group(function(){
            Route::get('/', [ArticleController::class, 'index'])->name('articles.get');
            Route::get('/detail', [ArticleController::class, 'getDetail'])->name('articles.getDetail');
            Route::get('/category', [ArticleController::class, 'getArticleFromCategory'])->name('articles.getArticleFromCategory');
            Route::get('/slug', [ArticleController::class, 'getDetailBySlug'])->name('articles.getDetailBySlug');
        });
        // Category Endpoint
        Route::prefix('categories')->group(function(){
            Route::get('/', [CategoryController::class, 'index'])->name('categories.get');
            Route::get('/detail', [CategoryController::class, 'getDetail'])->name('categories.getDetail');
        });
        // Informasi Sekolah Endpoint
        Route::prefix('informasi-sekolah')->group(function(){
            Route::get('/footer', [InformasiSekolahController::class, 'getFooter'])->name('informasi-sekolah.getFooter');
            Route::get('/visi-misi', [InformasiSekolahController::class, 'getVisiMisi'])->name('informasi-sekolah.getVisiMisi');
        });
         // Homepage Endpoint
        Route::prefix('portal')->group(function(){
            Route::get('/banner', [BannerController::class, 'index'])->name('banner.get');
            Route::get('/keunggulan-sekolah', [KeunggulanController::class, 'index'])->name('keunggulan-sekolah.get');
            Route::get('/fasilitas', [FasilitasController::class, 'index'])->name('fasilitas.get');
            Route::get('/sejarah', [SejarahController::class, 'index'])->name('sejarah.get');
            Route::get('/gallery', [GalleryController::class, 'index'])->name('gallery.get');
            Route::get('/sambutan', [SambutanController::class, 'index'])->name('sambutan.get');
        });
    });
});
