<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>SMK Taruna harapan 1 cipatat</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />
        {{-- @vite(['resources/css/app.css', 'resources/js/app.js']) --}}
        @vite('resources/css/app.css')
    </head>
    <body class="antialiased bg-dots-darker bg-center bg-gray-100 dark:bg-dots-lighter dark:bg-gray-900 selection:bg-red-500 selection:text-white">
        {{-- <div class="relative sm:flex sm:justify-center sm:items-center min-h-screen bg-dots-darker bg-center bg-gray-100 dark:bg-dots-lighter dark:bg-gray-900 selection:bg-red-500 selection:text-white">
            @if (Route::has('login'))
                <div class="sm:fixed sm:top-0 sm:right-0 p-6 text-right">
                    @auth
                        <a href="{{ url('/home') }}" class="font-semibold text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white focus:outline focus:outline-2 focus:rounded-sm focus:outline-red-500">Home</a>
                    @else
                        <a href="{{ route('login') }}" class="font-semibold text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white focus:outline focus:outline-2 focus:rounded-sm focus:outline-red-500">Log in</a>

                        @if (Route::has('register'))
                            <a href="{{ route('register') }}" class="ml-4 font-semibold text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white focus:outline focus:outline-2 focus:rounded-sm focus:outline-red-500">Register</a>
                        @endif
                    @endauth
                </div>
            @endif

            <div class="max-w-7xl mx-auto p-6 lg:p-8">
               
            </div>
        </div> --}}

        @include('theme-toggler')

        @php
            $links = [
                [
                    "title" => "Portal",
                    "link" => "https://smktarpan1.sch.id",
                    "description" => "Lorem ipsum dolor sit amet consectetur adipisicing elit. Nobis voluptates cumque pariatur. Qui, nostrum tempora!",
                ],
                [
                    "title" => "Master Data",
                    "link" => "https://masterdata.smktarpan1.sch.id",
                    "description" => "Lorem ipsum dolor sit amet consectetur adipisicing elit. Nobis voluptates cumque pariatur. Qui, nostrum tempora!",
                ],
                [
                    "title" => "E-Raport v2",
                    "link" => "https://e-raport.smktarpan1.sch.id",
                    "description" => "Lorem ipsum dolor sit amet consectetur adipisicing elit. Nobis voluptates cumque pariatur. Qui, nostrum tempora!",
                ],
                [
                    "title" => "ESPP",
                    "link" => " https://espp.smktarpan1.sch.id",
                    "description" => "Lorem ipsum dolor sit amet consectetur adipisicing elit. Nobis voluptates cumque pariatur. Qui, nostrum tempora!",
                ],
            ]
        @endphp

        <h1 class="my-[75px] text-slate-900 dark:text-slate-50 text-center text-3xl font-semibold uppercase">Portal</h1>

        <main class="container w-full min-h-fit mx-auto ">

            {{-- grid container --}}
              <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-3">

                @foreach ($links as $item)
                    {{-- <div class="p-4 rounded-md bg-white shadow-lg dark:bg-slate-800 group hover:bg-slate-100 dark:hover:bg-slate-700 transition-all duration-150">
                        <article class="mb-8">
                            <h1 class="text-2xl font-semibold text-slate-950 dark:text-slate-50">{{$item["title"]}}</h1>
                            <p class="text-slate-950 dark:text-slate-50 mt-5 text-md line-clamp-2 group-hover:line-clamp-none">{{$item["description"]}}</p>
                        </article>
                        <a 
                            target="_blank" 
                            href={{$item["link"]}} 
                            class="capitalize hover:bg-emerald-500 bg-emerald-700 text-slate-50 py-2 px-4 rounded-lg">visit</a>
                    </div> --}}

                    <div class="p-4 min-h-[250px] rounded-md bg-white shadow-lg dark:bg-slate-800 group hover:bg-slate-100 dark:hover:bg-slate-700 transition-all duration-150 flex group flex-col items-center justify-center hover:overflow-y-auto  overflow-hidden relative" >
                        <div class="relative md:group-hover:opacity-0 md:group-hover:scale-0  flex flex-col items-center transition duration-300">
                           <div class="max-w-30 rounded-full w-fit bg-slate-200 dark:bg-slate-600 group-hover:bg-primary">
                            <img 
                                loading='lazy' 
                                src='https://tarpantest.surge.sh/images/logo-tarpan.svg'
                                class='object-contain  w-full max-w-[100px]' alt="" />
                           </div>
                           <h1 class='font-semibold text-slate-950 dark:text-slate-50 capitalize'>{{$item["title"]}}</h1>
                        </div>
                        <div class='py-5 md:absolute inset-0  md:opacity-1 md:translate-y-[130%] flex flex-col justify-center  md:group-hover:translate-y-[0] md:inset-0 md:group-hover:opacity-1 transition duration-500 p-5'>
                            <div class='text-center'>
                             <h1 class='font-semibold hidden md:block text-slate-950 dark:text-slate-50 mb-5 capitalize'>{{$item["title"]}}</h1>
                              <p class='font-requler text-slate-950 dark:text-slate-50 capitalize mb-5'>{{$item["description"]}}</p>
                              <a 
                                target="_blank" 
                                href={{$item["link"]}} 
                                class="capitalize hover:bg-emerald-500 bg-emerald-700 text-slate-50 py-2 px-4 rounded-lg">visit</a>
                           </div>
                        </div>
                     </div>

                @endforeach

                



            </div>

        </main>

    </body>
</html>
