<!-- theme toggler -->
<div class="fixed  items-center bottom-3 right-3 flex flex-wrap gap-2">
   <button type="button" data-fortheme="default" class="shadow-lg inline-flex overflow-hidden text-slate-950 bg-slate-300 hover:bg-slate-300/70 rounded group">
      <span class="px-5 py-1">Default</span>
   </button>
   
   <button type="button" data-fortheme="dark" class="shadow-lg inline-flex overflow-hidden text-white bg-slate-700 hover:bg-slate-700/70 rounded group">
      <span class="px-4 py-1">dark</span>
   </button>
</div>

<script defer>
   const themes = ['default', 'dark'] // make sure its the same like in the tailwind config themeVariants
   const html = document.documentElement

   function setInitialTheme(){
         const localTheme = localStorage.getItem('theme')
         const activeTheme = themes.includes(localTheme)

         if(!activeTheme){
            localStorage.setItem('theme', 'default')
            html.classList.add('default')
         }else{
            html.classList.add(localTheme)
            
            // remove inactive theme
            const inActiveTheme = themes.filter(x => x !== localTheme)
            html.classList.remove(...inActiveTheme)

            localStorage.setItem('theme', localTheme)
         }
   }

   setInitialTheme()

   function setNewTheme(activeTheme){
         html.classList.add(activeTheme) 
         // remove inactive theme
         const inActiveTheme = themes.filter(x => x !== activeTheme)
         html.classList.remove(...inActiveTheme)

         localStorage.setItem('theme', activeTheme)
   }

   const btns = document.querySelectorAll('[data-fortheme]')

   btns.forEach(btn => {
      btn.addEventListener('click', function(e) {
         console.log('ok')
         const themeName = this.getAttribute('data-fortheme')
         setNewTheme(themeName)

      })
   })
</script>