<div x-data="{
    edit: false,
    edited: false,
    init() {
        window.livewire.on('fieldEdited', (id, column) => {
            if (id === '<?php echo e($rowId); ?>' && column === '<?php echo e($column); ?>') {
                this.edited = true
                setTimeout(() => {
                    this.edited = false
                }, 5000)
            }
        })
    }
}" x-init="init()" wire:key="<?php echo e($rowId); ?>_<?php echo e($column); ?>">
    <button class="min-h-[28px] w-full text-left hover:bg-blue-100 px-2 py-1 -mx-2 -my-1 rounded focus:outline-none" x-bind:class="{ 'text-green-600': edited }" x-show="!edit"
        x-on:click="edit = true; $nextTick(() => { $refs.input.focus() })"><?php echo htmlspecialchars($value); ?></button>
    <span x-cloak x-show="edit">
        <input class="border-blue-400 px-2 py-1 -mx-2 -my-1 rounded focus:outline-none focus:border" x-ref="input" value="<?php echo htmlspecialchars($value); ?>"
            wire:change="edited($event.target.value, '<?php echo e($key); ?>', '<?php echo e($column); ?>', '<?php echo e($rowId); ?>')"
            x-on:click.away="edit = false" x-on:blur="edit = false" x-on:keydown.enter="edit = false" />
    </span>
</div>
<?php /**PATH C:\laragon\www\revamp-eraport\resources\views/livewire/datatables/editable.blade.php ENDPATH**/ ?>