<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('user.index') }}" class="text-primary hover:underline">User</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>User</span>
        </li>
    </ul>

    <div x-data="{ open: true }">
        @if ($impersonateNotification = Session::get('impersonate'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                <div >
                    <p>{{ $impersonateNotification }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div>
        <div class="panel mt-6">
            <div class="flex">
                <h5 class="font-semibold text-lg dark:text-white-light">User</h5>
            </div>

            <livewire:users-table
                sort="created_at|desc"
            />

        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
