<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('absensi-raport.absensi') }}" class="text-primary hover:underline">Rekap Nilai</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Rekap Nilai Per Kelas</span>
        </li>
    </ul>

    <div>
        <div class="panel mt-6">
            <div class="flex">
                <h5 class="font-semibold text-lg dark:text-white-light">Rekap Nilai per Kelas</h5>
                <a href="{{route('rekap-nilai.index')}}" class="btn btn-primary ms-5">Reset</a>
            </div>

            <div class="flex">

                <form action="{{route('rekap-nilai.index')}}" method="GET">
                    <label for="kelas" class="mt-5">
                        Pilih Mapel
                    </label>
                    <select name="mapel" class="form-input w-32">
                        <option class="form-input" disabled selected>Pilih Mapel</option>
                        @foreach($mapel as $datamapel)
                        @if ($reqmapel != null)
                            <option class="form-input" value="{{$datamapel->mapel_id}}" @if($datamapel->mapel_id == $reqmapel) selected @endif disabled>{{$datamapel->mapel->nama_mapel}}</option>
                        @else
                            <option class="form-input" value="{{$datamapel->mapel_id}}">{{$datamapel->mapel->nama_mapel}}</option>
                        @endif
                        @endforeach
                    </select>
                    <button type="submit" class="btn btn-primary mt-5">Pilih</button>
                </form>


                @if (isset($reqmapel))
                    <form action="{{route('rekap-nilai.index')}}" method="GET" class="ms-5">
                        <label for="kelas" class="mt-5">
                            Pilih Kelas
                        </label>
                        <input type="hidden" name="mapel" value="{{ $reqmapel }}">
                        <select name="kelas" class="form-input w-32">
                            <option disabled selected>Pilih Kelas</option>
                            @foreach($kelas as $datakelas)
                                <option value="{{$datakelas->kelas->id}}" @if($datakelas->kelas->id == $reqkelas) selected @endif>{{$datakelas->kelas->nama_kelas}}</option>
                            @endforeach
                            </select>
                        <button type="submit" class="btn btn-primary mt-5">Pilih</button>
                    </form>
                @endif
            </div>


            @if (isset($reqkelas))
            <div class="panel mt-6">
                <div class="flex">
                    <h5 class="mb-4 font-semibold text-lg dark:text-white-light">Rekap Nilai Pengetahuan -</h5>
                </div>
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th rowspan="2" class="text-center">No</th>
                                <th rowspan="2" class="text-center">Nama</th>
                                <th colspan="{{ $kdp->count() }}" style="text-align: center !important;">Pengetahuan ({{ $rasio->rate_nilai_harian }}%)</th>
                                <th colspan="{{ $kdk->count() }}" style="text-align: center !important;">Keterampilan ({{ $rasio->rate_nilai_harian }}%)</th>
                                <th rowspan="2" class="text-center" style="text-align: center !important;">PTS ({{ $rasio->rate_pts }}%)</th>
                                <th rowspan="2" class="text-center" style="text-align: center !important;">PAS ({{ $rasio->rate_pas }}%)</th>
                                <th rowspan="2" class="text-center" style="text-align: center !important;">Nilai Akhir Pengetahuan</th>
                                <th rowspan="2" class="text-center" style="text-align: center !important;">Nilai Akhir Keterampilan</th>
                                <th rowspan="2" class="text-center" style="text-align: center !important;">Nilai Total</th>
                            </tr>
                            <tr>
                            @foreach ($kdp as $datakdp)
                                <th class="text-center" style="text-align: center !important;">{{ $datakdp->kode_kd }}</th>
                            @endforeach
                            @foreach ($kdk as $datakdk)
                                <th class="text-center" style="text-align: center !important;">{{ $datakdk->kode_kd }}</th>
                            @endforeach
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $i = 1;
                            @endphp
                            @foreach ($data as $key => $value)
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $value['nama_siswa'] }}</td>
                                    @foreach($value['nilai']['pengetahuan'] as $np)
                                    <td style="text-align: center !important; @if((int)$np < 75) {{'color: red;'}} @endif">{{ $np ?? '-' }}</td>
                                    @endforeach
                                    @foreach($value['nilai']['keterampilan'] as $nk)
                                    <td style="text-align: center !important; @if((int)$nk < 75) {{'color: red;'}} @endif">{{ $nk ?? '-' }}</td>
                                    @endforeach
                                    <td style="text-align: center !important; @if((int)@$value['nilai']['pts'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['pts'] ?? '-' }}</td>
                                    <td style="text-align: center !important; @if((int)@$value['nilai']['pas'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['pas'] ?? '-' }}</td>
                                    <td style="text-align: center !important; @if((int)@$value['nilai']['rataRataPengetahuan'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['rataRataPengetahuan'] }}</td>
                                    <td style="text-align: center !important; @if((int)@$value['nilai']['rataRataKeterampilan'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['rataRataKeterampilan'] }}</td>
                                    <td style="text-align: center !important; @if((int)@$value['nilai']['rataRata'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['rataRata'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            @endif



        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
