<x-layout.default>

    <div>
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="javascript:;" class="text-primary hover:underline">Users</a>
            </li>
            <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
                <span>Account Settings</span>
            </li>
        </ul>
        <div class="pt-5">
            <div class="flex items-center justify-between mb-5">
                <h5 class="font-semibold text-lg dark:text-white-light">Settings</h5>
            </div>
            <div>
                <form class="border border-[#ebedf2] dark:border-[#191e3a] rounded-md p-4 mb-5 bg-white dark:bg-[#0e1726]" action="{{ route('profil.update',$data->id) }}" method="post">
                    @csrf
                    <h6 class="text-lg font-bold mb-5">General Information</h6>
                    <div class="flex flex-col sm:flex-row">
                        <div class="ltr:sm:mr-4 rtl:sm:ml-4 w-full sm:w-2/12 mb-5">
                            <img src="/assets/images/profile-34.jpeg" alt="image"
                                class="w-20 h-20 md:w-32 md:h-32 rounded-full object-cover mx-auto" />
                        </div>
                        <div class="flex-1 grid grid-cols-1 sm:grid-cols-2 gap-5">
                            <div>
                                <label for="name">Name</label>
                                <input id="name" name="name" type="text" class="form-input" value="{{ $data->name }}"/>
                                @error('name')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="email">Email</label>
                                <input id="email" name="email" type="email" class="form-input" value="{{ $data->email }}" readonly/>
                                @error('email')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="password">Password</label>
                                <input id="password" name="password" type="password" class="form-input" />
                                @error('password')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div>
                                <label for="password">Password Confirmation</label>
                                <input id="password" name="password_confirmation" type="password" class="form-input" />
                                @error('password_confirmation')
                                    <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="sm:col-span-2 mt-3">
                                <button type="submit" class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
    </div>

</x-layout.default>
