<x-layout.default>

    <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
        <ul class="flex space-x-2 rtl:space-x-reverse">
            <li>
                <a href="{{ route('nilai-sikap-spiritual.index') }}" class="text-primary hover:underline">Nilai Sikap Spiritual</a>
            </li>
        </ul>
        <div class="pt-5">
            <div x-data="{ open: true }">
                @if ($sukses = Session::get('sukses'))
                    <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                        <div >
                            <p>{{ $sukses }}</p>
                        </div>
                        <button type="button" aria-label="Close" x-on:click="open = ! open">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                <line x1="6" y1="6" x2="18" y2="18"></line>
                            </svg>
                        </button>
                    </div>
                @endif
            </div>
            <div x-data="{ open: true }">
                @if ($fail = Session::get('fail'))
                    <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-red-600 bg-red-200 border-red-400" role="alert">
                        <div >
                            <p>{{ $fail }}</p>
                        </div>
                        <button type="button" aria-label="Close" x-on:click="open = ! open">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                                <line x1="18" y1="6" x2="6" y2="18"></line>
                                <line x1="6" y1="6" x2="18" y2="18"></line>
                            </svg>
                        </button>
                    </div>
                @endif
            </div>
            <div class="grid mb-5 mt-5">

                <div class="panel col-span-3 lg:col-span-3">
                    <div class="flex items-center justify-between mb-5">
                        <h5 class="font-semibold text-lg dark:text-white-light">Nilai Sikap Spritual</h5>
                    </div>

                    <div class="col-span-3 justify-start items-start">
                            <form action="{{ route('nilai-sikap-spiritual.store') }}" method="POST">
                                <input type="hidden" name="tahun_ajaran_id" value="{{ $tahun_ajaran->id }}" required />
                                <input type="hidden" name="mapping_walikelas_id" value="{{ $mapping_walikelas->id }}" required />
                                <input type="hidden" name="kelas_id" value="{{ $mapping_walikelas->kelas->id }}" required />
                                @csrf
                                <div class="table-responsive">
                                    <table>
                                        <thead>
                                            <tr>
                                                <th rowspan="2">No</th>
                                                <th rowspan="2">Nama</th>
                                                <th >Selalu Dilakukan</th>
                                                <th></th>
                                                <th rowspan="2">Mulai Meningkat</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php
                                                $i = 1;
                                            @endphp
                                            @foreach ($mapping_siswa as $datasiswa)
                                                @php
                                                    $dataNilai = $nilaiSikapSpiritual->where('siswa_id', $datasiswa->siswa_id)->first();
                                                    $dataNilaiMulaiMeningkat = $nilaiSikapSpiritual->where('siswa_id', $datasiswa->siswa_id)->where('type','mulai_meningkat')->first();
                                                    $dataNilaiSelalu = $nilaiSikapSpiritual->where('siswa_id', $datasiswa->siswa_id)->where('type','selalu')->first();
                                                @endphp
                                                <tr>
                                                    <td>{{ $i++ }}</td>
                                                    <td>{{ $datasiswa->siswa->nama_siswa }}</td>
                                                    <input type="hidden" name="siswa[{{ $datasiswa->siswa_id }}][siswa_id]" value="{{ $datasiswa->siswa_id }}" />
                                                    @if ($dataNilai)
                                                        <td>
                                                            <select name="siswa[{{ $datasiswa->siswa_id }}][selalu1]" class="form-input">
                                                                <option value="">Pilih nilai selalu dilakukan</option>
                                                                @foreach ($masterNilai as $data)
                                                                    <option value="{{ $data->kode }}" @if ($data->id == $selalu1->master_nilai_sikap_id)
                                                                        {{ 'selected' }}
                                                                    @endif>{{ $data->nama }}</option>
                                                                @endforeach
                                                            </select>
                                                            @error('siswa.' . $datasiswa->siswa_id . '.selalu1')
                                                                <span>
                                                                    <strong style="color: red;">{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </td>
                                                        <td>
                                                            <select name="siswa[{{ $datasiswa->siswa_id }}][selalu2]" class="form-input">
                                                                <option value="">Pilih nilai selalu dilakukan</option>
                                                                @foreach ($masterNilai as $data)
                                                                    <option value="{{ $data->kode }}" @if ($data->id == $selalu2->master_nilai_sikap_id)
                                                                        {{ 'selected' }}
                                                                    @endif>{{ $data->nama }}</option>
                                                                @endforeach
                                                            </select>
                                                            @error('siswa.' . $datasiswa->siswa_id . '.selalu2')
                                                                <span>
                                                                    <strong style="color: red;">{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </td>
                                                        <td>
                                                            <select name="siswa[{{ $datasiswa->siswa_id }}][mulai_meningkat]" class="form-input">
                                                                <option value="">Pilih nilai mulai meningkat</option>
                                                                @foreach ($masterNilai as $data)
                                                                    <option value="{{ $data->kode }}" @if ($data->id == $dataNilaiMulaiMeningkat->master_nilai_sikap_id)
                                                                        {{ 'selected' }}
                                                                    @endif>{{ $data->nama }}</option>
                                                                @endforeach
                                                            </select>
                                                            @error('siswa.' . $datasiswa->siswa_id . '.mulai_meningkat')
                                                                <span>
                                                                    <strong style="color: red;">{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </td>
                                                    @else
                                                    <td>
                                                        <select name="siswa[{{ $datasiswa->siswa_id }}][selalu1]" class="form-input">
                                                            <option value="">Pilih nilai selalu dilakukan</option>
                                                            @foreach ($masterNilai as $data)
                                                                <option value="{{ $data->kode }}">{{ $data->nama }}</option>
                                                            @endforeach
                                                        </select>
                                                        @error('siswa.' . $datasiswa->siswa_id . '.selalu')
                                                            <span>
                                                                <strong style="color: red;">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </td>
                                                    <td>
                                                        <select name="siswa[{{ $datasiswa->siswa_id }}][selalu2]" class="form-input">
                                                            <option value="">Pilih nilai selalu dilakukan</option>
                                                            @foreach ($masterNilai as $data)
                                                                <option value="{{ $data->kode }}">{{ $data->nama }}</option>
                                                            @endforeach
                                                        </select>
                                                        @error('siswa.' . $datasiswa->siswa_id . '.selalu')
                                                            <span>
                                                                <strong style="color: red;">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </td>
                                                    <td>
                                                        <select name="siswa[{{ $datasiswa->siswa_id }}][mulai_meningkat]" class="form-input">
                                                            <option value="">Pilih nilai mulai meningkat</option>
                                                            @foreach ($masterNilai as $data)
                                                                <option value="{{ $data->kode }}">{{ $data->nama }}</option>
                                                            @endforeach
                                                        </select>
                                                        @error('siswa.' . $datasiswa->siswa_id . '.mulai_meningkat')
                                                            <span>
                                                                <strong style="color: red;">{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                    </td>
                                                    @endif
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>

                                    <button type="submit" class="btn btn-primary mt-5">SIMPAN</button>

                                </div>
                                </div>
                            </form>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script>
        function toggleAccordion(panelId) {
            const panel = document.getElementById(panelId);
            const icon = document.getElementById(`icon${panelId}`);

            panel.classList.toggle('hidden');
            icon.classList.toggle('rotate-180');
        }
    </script>

</x-layout.default>


