<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <a href="{{ route('mapel-diampu.show',
            [
                'id' => request()->mapel_id,
                'tahun_ajaran_id' => request()->tahun_ajaran_id,
            ]
            ) }}" class="text-primary hover:underline">{{ \App\Models\Mapel::find($mapel)->nama_mapel }}</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Nilai SAS/PAS</span>
        </li>
    </ul>

    <div x-data="{ open: true }">
        @if ($sukses = Session::get('sukses'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-green-600 bg-green-200 border-green-400" role="alert">
                <div >
                    <p>{{ $sukses }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div x-data="{ open: true }">
        @if ($fail = Session::get('fail'))
            <div x-show="open" x-transition class="block text-sm mt-5 text-left border flex justify-between px-4 py-3 rounded-sm text-red-600 bg-red-200 border-red-400" role="alert">
                <div >
                    <p>{{ $fail }}</p>
                </div>
                <button type="button" aria-label="Close" x-on:click="open = ! open">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                    </svg>
                </button>
            </div>
        @endif
    </div>

    <div class="flex flex-wrap justify-left">
        <div class="panel mt-6">
            <div class="flex">
                <h5 class="font-semibold text-lg dark:text-white-light">Nilai SAS/PAS</h5>
                <div x-data="modal" class="mb-5 ms-auto">
                    <!-- button -->
                    <div class="flex items-center justify-center">
                        <button type="button" class="btn btn-info btn-sm" @click="toggle">
                            Import Nilai SAS/PAS
                        </button>
                    </div>

                    <!-- modal -->
                    <div class="fixed inset-0 bg-[black]/60 z-[999] hidden overflow-y-auto" :class="open && '!block'">
                        <div class="flex items-start justify-center min-h-screen px-4" @click.self="open = false">
                            <div x-show="open" x-transition x-transition.duration.300 class="panel border-0 p-0 rounded-lg overflow-hidden my-8 w-full max-w-lg">
                                <div class="flex bg-[#fbfbfb] dark:bg-[#121c2c] items-center justify-between px-5 py-3">
                                    <div class="font-bold text-lg">Form Upload Nilai SAS/PAS</div>
                                </div>
                                <div class="p-5">
                                    <div class="dark:text-white-dark/70 text-base font-medium text-[#1f2937]">
                                        <div class="mb-4 inline-block">
                                            <a class="btn btn-warning btn-sm btn-" href="{{ route('nilai-pengetahuan.downloadTemplate', ['kelas_id' => request()->kelas_id, 'tahun_ajaran_id' => request()->tahun_ajaran_id ]) }}">Download Template Import - {{ \App\Models\Kelas::find(request()->kelas_id)->nama_kelas }}</a>
                                        </div>
                                        <form action="{{ route('nilai-pas.import',[
                                            'mapel_id' => $mapel,
                                            'kelas_id' => request()->kelas_id,
                                            'tahun_ajaran_id' => request()->tahun_ajaran_id,
                                            'mapping_guru_id' => request()->mapping_guru_id
                                        ]) }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <label for="">File</label>
                                            <input type="file" name="file" class="form-input">
                                    </div>
                                    <div class="flex justify-end items-center mt-8">
                                        <button type="button" class="btn btn-outline-danger" @click="toggle">Batal</button>
                                        <button type="submit" class="btn btn-primary ltr:ml-4 rtl:mr-4" >Simpan</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <form action="{{ route('nilai-pas.store') }}" method="POST">
                @csrf
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Nama</th>
                                <th>Nilai</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $i = 1;
                            @endphp
                            @foreach ($mapping_siswa as $datasiswa)
                                @php
                                    $datanilai = $nilai_pas->where('siswa_id', $datasiswa->siswa_id)->where('mapping_guru_id',$mapping_guru)->first();
                                @endphp
                                <tr>
                                    <td>{{ $i++ }}</td>
                                    <td>{{ $datasiswa->siswa->nama_siswa }}</td>
                                    @if ($datanilai)
                                        <td><input type="number" class="form-input" name="siswa[{{ $datasiswa->siswa_id }}][nilai]" value="{{ $datanilai->nilai }}" required /></td>
                                    @else
                                        <td><input type="number" class="form-input" name="siswa[{{ $datasiswa->siswa_id }}][nilai]" value="0" required /></td>
                                    @endif
                                </tr>
                                <input type="hidden" name="tahun_ajaran_id" value="{{ $tahun_ajaran }}" required />
                                <input type="hidden" name="mapping_guru_id" value="{{ $mapping_guru }}" required />
                                <input type="hidden" name="kelas_id" value="{{ $kelas }}" required />
                            @endforeach
                        </tbody>
                    </table>

                    <button type="submit" class="btn btn-primary mt-5">SIMPAN</button>

                </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>


</x-layout.default>
