<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('mapel-diampu.index') }}" class="text-primary hover:underline">Mapel Diampu</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <a href="{{ route('mapel-diampu.show', $mapel) }}" class="text-primary hover:underline">{{ \App\Models\Mapel::find($mapel)->nama_mapel }}</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Rekap Nilai Keterampilan</span>
        </li>
    </ul>

    <div class="panel mt-6">
            <div class="flex">
                <h5 class="mb-4 font-semibold text-lg dark:text-white-light">Rekap Nilai Keterampilan - {{ \App\Models\Kelas::find($kelas)->nama_kelas }}</h5>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th rowspan="2" class="text-center">No</th>
                            <th rowspan="2" class="text-center">Nama</th>
                            <th colspan="{{ $kd->count() }}" style="text-align: center !important;">KD ({{ $rasio->rate_nilai_harian }}%)</th>
                            <th rowspan="2" class="text-center" style="text-align: center !important;">PTS ({{ $rasio->rate_pts }}%)</th>
                            <th rowspan="2" class="text-center" style="text-align: center !important;">PAS ({{ $rasio->rate_pas }}%)</th>
                            <th rowspan="2" class="text-center" style="text-align: center !important;">Rata Rata Nilai</th>
                        </tr>
                        <tr>
                        @foreach ($kd as $datakd)
                            <th class="text-center" style="text-align: center !important;">{{ $datakd->kode_kd }}</th>
                        @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $i = 1;
                        @endphp
                        @foreach ($data as $key => $value)
                            <tr>
                                <td>{{ $i++ }}</td>
                                <td>{{ $value['nama_siswa'] }}</td>
                                @foreach($value['nilai']['keterampilan'] as $nk)
                                    <td style="text-align: center !important; @if((int)$nk < 75) {{'color: red;'}} @endif">{{ $nk ?? '-' }}</td>
                                @endforeach
                                <td style="text-align: center !important; @if((int)@$value['nilai']['pts'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['pts'] ?? '-' }}</td>
                                <td style="text-align: center !important; @if((int)@$value['nilai']['pas'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['pas'] ?? '-' }}</td>
                                <td style="text-align: center !important; @if((int)$value['nilai']['rataRata'] < 75) {{'color: red;'}} @endif">{{ $value['nilai']['rataRata'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>


</x-layout.default>
