<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('master-ekskul.index') }}" class="text-primary hover:underline">Master Ekstrakulikuler</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Edit Master Ekstrakulikuler</span>
        </li>
    </ul>

    <!-- card 1 -->
    <div class="w-full rounded border border-[#e0e6ed] dark:border-[#1b2e4b] dark:bg-[#191e3a] dark:shadow-none">
        <div class="py-7 px-6">
            <h5 class="text-[#3b3f5c] text-xl mt-5 font-semibold mb-4 dark:text-white-light">Tambah Data</h5>
            <form class="space-y-5 mt-5 mb-5" action="{{ route('master-ekskul.update', $master_ekskul->id) }}" method="POST">
                @csrf
                <div>
                    <label for="groupFname">Nama Ekstrakulikuler</label>
                    <input type="text" name="nama_ekskul" class="form-input" value="{{ $master_ekskul->nama_ekskul }}">
                    @error('nama_ekskul')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label for="groupFname">Deskripsi</label>
                    <textarea name="deskripsi" class="form-input" cols="30" rows="10">{{ $master_ekskul->deskripsi }}</textarea>
                    @error('deskripsi')
                        <p class="text-danger">{{ $message }}</p>
                    @enderror
                </div>
                <button type="submit" class="btn btn-primary !mt-6 ml-auto">Edit</button>
            </form>
        </div>
    </div>

</x-layout.default>
