
<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse" id="breadcrumb">
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Cetak Legger</span>
        </li>
    </ul>

    <div id="layout">
        <div class="panel mt-6">
            <div class="grid grid-cols-3 gap-3">
                <h5 class="font-semibold text-lg dark:text-white-light">Cetak Legger</h5>
            </div>

            <label for="kelas" class="mt-5">
                    Pilih Kelas
            </label>

            <div class="grid grid-cols-3 gap-4">
                <form action="{{route('cetak-legger.index')}}" method="GET" class="col-span-3">
                    <select name="kelas" class="form-input mt-3">
                        <option disabled selected>Pilih Kelas</option>
                        @if (auth()->user()->hasRole('walikelas'))
                            @foreach($kelas as $data)
                                @if($data->id == request()->kelas || $data->id == request()->id)
                                    <option selected value="{{ $data->id }}">{{ $data->nama_kelas }}</option>
                                @endif
                            @endforeach
                        @else
                            @foreach($kelas as $data)
                                <option @if($data->id == request()->kelas || $data->id == request()->id) selected  @endif value="{{ $data->id }}">{{ $data->nama_kelas }}</option>
                            @endforeach
                        @endif
                    </select>

                    <select name="tahun_ajaran" class="form-input mt-3">
                        <option disabled selected required>Pilih Tahun Ajaran</option>
                        @if (auth()->user()->hasRole('walikelas'))
                            @foreach($tahun_ajaran as $data)
                                @if($data->is_active == 1)
                                    <option  value="{{$data->id}}" selected>{{$data->nama_tahun_ajaran}}</option>
                                @endif
                            @endforeach
                        @else
                        @foreach($tahun_ajaran as $data)
                            <option @if($data->id == request()->tahun_ajaran) selected @endif value="{{$data->id}}">{{$data->nama_tahun_ajaran}}</option>
                        @endforeach
                        @endif
                    </select>

                    <select name="semester" class="form-input mt-3">
                        <option disabled selected required>Pilih Semester</option>
                        @foreach($semester as $data)
                        <option @if($data->id == request()->semester) selected @endif value="{{$data->id}}">{{$data->kode}}</option>
                        @endforeach
                    </select>

                    @php
                    $reqKelas = request()->get('kelas');
                    $reqTahunAjaran = request()->get('tahun_ajaran');
                    $reqSemester = request()->get('semester');
                    @endphp
                    @if(isset($reqKelas))
                    <div class="mt-2 col-span-3">
                        <p class="text-md">Kelas yang dipilih: <span class="font-bold">{{ \App\Models\Kelas::find($reqKelas)->nama_kelas }}</span></p>
                    </div>
                    @endif

                    <button type="submit" class="btn btn-primary mt-5 col-span-3">Pilih Kelas</button>
                </form>
            </div>



        </div>
    </div>
    <div id="table">
        <div class="py-5">
            @if (isset($reqKelas))
                <div class="flex me-auto">
                    <button id="printButton" class="btn btn-danger m-5">Print</button>
                    <a href="{{ route('cetak-legger.export',
                    [
                        'reqkelas' => $reqKelas,
                        'reqtahunAjaran' => $reqTahunAjaran,
                        'reqsemester' => $reqSemester,

                    ]
                    ) }}" class="btn btn-success m-5">Print</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="table-auto min-w-full" id="table-legger">
                        <thead class="table-head">
                        <tr>
                            <th rowspan="2">Nama</th>
                            @php
                                $firstKey = '';
                            @endphp
                            @foreach ($hasil as $key => $value)
                                @if ($loop->first)
                                    @php
                                        $firstKey = $key;
                                    @endphp
                                @endif
                            @endforeach
                            @foreach ($hasil[$firstKey]['nilai'] as $mapel => $value)
                                    <th colspan="2">{{ $mapel }}</th>
                            @endforeach
                        </tr>
                        <tr>
                            @php
                                $firstKey = '';
                            @endphp
                            @foreach ($hasil as $key => $value)
                                @if ($loop->first)
                                    @php
                                        $firstKey = $key;
                                    @endphp
                                @endif
                            @endforeach
                            @foreach ($hasil[$firstKey]['nilai'] as $mapel => $value)
                                    <th>NP</th>
                                    <th>NK</th>
                            @endforeach
                        </tr>
                        </thead>
                        <tbody class="table-body">
                            @foreach ($hasil as $key => $value)
                                <tr>
                                    <td>{{ $value['nama'] }}</td>
                                        @foreach ($value['nilai'] as $key => $value)
                                            <td @if ($value['NP'] < 75)
                                                class="text-danger"
                                            @endif>{{ $value['NP'] }}</td>
                                            <td @if ($value['NK'] < 75)
                                            class="text-danger"
                                            @endif>{{ $value['NK'] }}</td>
                                        @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
    </div>
    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
        document.getElementById('printButton').addEventListener('click', function() {
            window.print();
        });
    </script>

</x-layout.default>
