<div :class="{ 'dark text-white-dark': $store.app.semidark }">
    <nav x-data="sidebar"
        class="sidebar fixed min-h-screen h-full top-0 bottom-0 w-[260px] shadow-[5px_0_25px_0_rgba(94,92,154,0.1)] z-50 transition-all duration-300">
        <div class="bg-white dark:bg-[#0e1726] h-full">
            <div class="flex justify-between items-center px-4 py-3">
                <a href="/" class="main-logo flex items-center shrink-0">
                    <img class="w-8 ml-[5px] flex-none" src="/android-chrome-192x192.png"
                        alt="image" />
                    <span
                        class="text-2xl ltr:ml-1.5 rtl:mr-1.5  font-semibold  align-middle lg:inline dark:text-white-light">ERaport v2</span>
                </a>
                <a href="javascript:;"
                    class="collapse-icon w-8 h-8 rounded-full flex items-center hover:bg-gray-500/10 dark:hover:bg-dark-light/10 dark:text-white-light transition duration-300 rtl:rotate-180"
                    @click="$store.app.toggleSidebar()">
                    <svg class="w-5 h-5 m-auto" width="20" height="20" viewBox="0 0 24 24" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M13 19L7 12L13 5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                            stroke-linejoin="round" />
                        <path opacity="0.5" d="M16.9998 19L10.9998 12L16.9998 5" stroke="currentColor"
                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </a>
            </div>
            <ul class="perfect-scrollbar relative font-semibold space-y-0.5 h-[calc(100vh-80px)] overflow-y-auto overflow-x-hidden  p-4 py-0"
                x-data="{ activeDropdown: null }">
                <li class="menu nav-item">
                    <a href="{{ route('index') }}" class="nav-link group">
                        <div class="flex items-center">
                            <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.5"
                                    d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                    fill="currentColor" />
                                <path
                                    d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                    fill="currentColor" />
                                </svg>
                            <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Dashboard</span>
                        </div>
                    </a>
                </li>

                @if(auth()->user()->hasAnyRole('superadmin', 'admin'))
                    <h2 class="-mx-4 mb-1 flex items-center bg-white-light/30 px-7 py-3 font-extrabold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                        <svg
                            class="hidden h-5 w-4 flex-none"
                            viewBox="0 0 24 24"
                            stroke="currentColor"
                            stroke-width="1.5"
                            fill="none"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        >
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <span>Menu Admin</span>
                    </h2>

                    <li class="menu nav-item">
                        <a href="{{ route('setting-rate-nilai.index') }}" class="nav-link group">
                            <div class="flex items-center">
                                <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.5"
                                          d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                          fill="currentColor" />
                                    <path
                                        d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                        fill="currentColor" />
                                </svg>
                                <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Setting Rate Nilai</span>
                            </div>
                        </a>
                    </li>
                    <li class="menu nav-item">
                        <a href="{{ route('master-ekskul.index') }}" class="nav-link group">
                            <div class="flex items-center">
                                <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.5"
                                          d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                          fill="currentColor" />
                                    <path
                                        d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                        fill="currentColor" />
                                </svg>
                                <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Master Ekstrakulikuler</span>
                            </div>
                        </a>
                    </li>
                    <li class="menu nav-item">
                        <a href="{{ route('master-nilai-sikap.index') }}" class="nav-link group">
                            <div class="flex items-center">
                                <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.5"
                                          d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                          fill="currentColor" />
                                    <path
                                        d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                        fill="currentColor" />
                                </svg>
                                <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Master Nilai Sikap</span>
                            </div>
                        </a>
                    </li>
                    <li class="menu nav-item">
                        <a href="{{ route('cetak-legger.index') }}" class="nav-link group">
                            <div class="flex items-center">
                                <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                     fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.5"
                                          d="M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z"
                                          fill="currentColor" />
                                    <path
                                        d="M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z"
                                        fill="currentColor" />
                                </svg>
                                <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Legger</span>
                            </div>
                        </a>
                    </li>

                <li class="menu nav-item">
                    <button type="button" class="nav-link group" :class="{ 'active': activeDropdown === 'cetak-raport' }"
                            @click="activeDropdown === 'cetak-raport' ? activeDropdown = null : activeDropdown = 'cetak-raport'">
                        <div class="flex items-center">

                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M6 17.9827C4.44655 17.9359 3.51998 17.7626 2.87868 17.1213C2 16.2426 2 14.8284 2 12C2 9.17157 2 7.75736 2.87868 6.87868C3.75736 6 5.17157 6 8 6H16C18.8284 6 20.2426 6 21.1213 6.87868C22 7.75736 22 9.17157 22 12C22 14.8284 22 16.2426 21.1213 17.1213C20.48 17.7626 19.5535 17.9359 18 17.9827" stroke="currentColor" stroke-width="1.5"/>
                                <path opacity="0.5" d="M9 10H6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M19 15L5 15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                <path d="M18 15V16C18 18.8284 18 20.2426 17.1213 21.1213C16.2426 22 14.8284 22 12 22C9.17157 22 7.75736 22 6.87868 21.1213C6 20.2426 6 18.8284 6 16V15" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                <path opacity="0.5" d="M17.9827 6C17.9359 4.44655 17.7626 3.51998 17.1213 2.87868C16.2427 2 14.8284 2 12 2C9.17158 2 7.75737 2 6.87869 2.87868C6.23739 3.51998 6.06414 4.44655 6.01733 6" stroke="white" stroke-width="1.5"/>
                                <circle opacity="0.5" cx="17" cy="10" r="1" fill="currentColor"/>
                            </svg>

                            <span
                                class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Cetak Raport</span>
                        </div>
                        <div class="rtl:rotate-180" :class="{ '!rotate-90': activeDropdown === 'cetak-raport' }">

                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                      stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </button>
                    <ul x-cloak x-show="activeDropdown === 'cetak-raport'" x-collapse class="sub-menu text-gray-500">
                        <li>
                            <a href="{{ route('cetak-sampul-raport.index') }}">Cetak Raport</a>
                        </li>
                        <li>
                            <a href="{{ route('absensi-raport.absensi') }}">Cetak Absensi Raport</a>
                        </li>
                        <li>
                            <a href="{{ route('cetak-rangking.index') }}">Cetak Rangking</a>
                        </li>
                    </ul>
                </li>

                <li class="menu nav-item">
                    <button type="button" class="nav-link group" :class="{ 'active': activeDropdown === 'users' }"
                            @click="activeDropdown === 'users' ? activeDropdown = null : activeDropdown = 'users'">
                        <div class="flex items-center">

                            <svg class="group-hover:!text-primary shrink-0" width="20" height="20" viewBox="0 0 24 24"
                                 fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle opacity="0.5" cx="15" cy="6" r="3"
                                        fill="currentColor" />
                                <ellipse opacity="0.5" cx="16" cy="17" rx="5" ry="3"
                                         fill="currentColor" />
                                <circle cx="9.00098" cy="6" r="4" fill="currentColor" />
                                <ellipse cx="9.00098" cy="17.001" rx="7" ry="4"
                                         fill="currentColor" />
                            </svg>
                            <span
                                class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Users</span>
                        </div>
                        <div class="rtl:rotate-180" :class="{ '!rotate-90': activeDropdown === 'users' }">

                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                                 xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                      stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </button>
                    <ul x-cloak x-show="activeDropdown === 'users'" x-collapse class="sub-menu text-gray-500">
                        <li>
                            <a href="{{ route('user.index') }}">Manage User</a>
                        </li>
                    </ul>
                </li>

                @endif
                <!-- End Menu Superadmin -->

                @if(auth()->user()->hasRole('guru'))
                <h2 class="-mx-4 mb-1 flex items-center bg-white-light/30 px-7 py-3 font-extrabold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                    <svg
                        class="hidden h-5 w-4 flex-none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                        stroke-width="1.5"
                        fill="none"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                    >
                        <line x1="5" y1="12" x2="19" y2="12"></line>
                    </svg>
                    <span>Menu Guru</span>
                </h2>

                <li class="menu nav-item">
                    <button type="button" class="nav-link group" :class="{ 'active': activeDropdown === 'mapeldiampu' }"
                        @click="activeDropdown === 'mapeldiampu' ? activeDropdown = null : activeDropdown = 'mapeldiampu'">
                        <div class="flex items-center">

                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                            </svg>


                            <span
                                class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Mapel Diampu</span>
                        </div>
                        <div class="rtl:rotate-180" :class="{ '!rotate-90': activeDropdown === 'mapeldiampu' }">

                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                    stroke-linecap="round" stroke-linejoin="round" />
                            </svg>
                        </div>
                    </button>
                    <ul x-cloak x-show="activeDropdown === 'mapeldiampu'" x-collapse class="sub-menu text-gray-500">
                        <li>
                            <a href="{{ route('mapel-diampu.index') }}">Mapel Diampu</a>
                        </li>
                    </ul>
                </li>
                <li class="menu nav-item">
                    <a href="{{ route('rekap-nilai.index') }}" class="nav-link group">
                        <div class="flex items-center">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                            </svg>
                            <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Rekap Nilai</span>
                        </div>
                    </a>
                </li>
                @endif
                <!-- End Menu Guru -->

                @if(auth()->user()->hasRole('walikelas'))
                    @php
                        $activeTahunAjaran = \App\Models\TahunAjaran::where('is_active', true)->first();
                        $mappingWaliKelas = \App\Models\MappingWaliKelas::with('kelas')
                            ->where('tahun_ajaran_id', $activeTahunAjaran->id)
                            ->where('guru_id', auth()->user()->model_id)->first();
                    @endphp
                    @if($mappingWaliKelas !== null)
                    <h2 class="-mx-4 mb-1 flex items-center bg-white-light/30 px-7 py-3 font-extrabold uppercase dark:bg-dark dark:bg-opacity-[0.08]">
                        <svg
                            class="hidden h-5 w-4 flex-none"
                            viewBox="0 0 24 24"
                            stroke="currentColor"
                            stroke-width="1.5"
                            fill="none"
                            stroke-linecap="round"
                            stroke-linejoin="round"
                        >
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <span>Menu Walikelas</span>
                    </h2>

                        <li class="menu nav-item">
                            <button type="button" class="nav-link group" :class="{ 'active': activeDropdown === 'kelassiswa' }"
                                    @click="activeDropdown === 'kelassiswa' ? activeDropdown = null : activeDropdown = 'kelassiswa'">
                                <div class="flex items-center">

                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span
                                        class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Kelas Siswa</span>
                                </div>
                                <div class="rtl:rotate-180" :class="{ '!rotate-90': activeDropdown === 'kelassiswa' }">

                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </button>
                            <ul x-cloak x-show="activeDropdown === 'kelassiswa'" x-collapse class="sub-menu text-gray-500">
                                <li>
                                    <a href="{{ route('list-siswa.index') }}">List Siswa</a>
                                </li>
                            </ul>
                            <ul x-cloak x-show="activeDropdown === 'kelassiswa'" x-collapse class="sub-menu text-gray-500">
                                <li>
                                    <a href="{{ route('cetak-rangking.index') }}">Cetak Ranking</a>
                                </li>
                            </ul>
                        </li>

                        <!-- Temporary disable -->
                        @if(auth()->user()->hasRole('walikelas'))
                        {{-- <li class="menu nav-item">
                            @if ($mappingWaliKelas->kelas->tingkatan->kode_tingkatan === 'XII')
                            <button type="button" class="nav-link group" :class="{ 'active': activeDropdown === 'inputnilaisikap' }"
                                    @click="activeDropdown === 'inputnilaisikap' ? activeDropdown = null : activeDropdown = 'inputnilaisikap'">
                                <div class="flex items-center">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span
                                        class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Nilai Sikap</span>
                                </div>
                                <div class="rtl:rotate-180" :class="{ '!rotate-90': activeDropdown === 'inputnilaisikap' }">

                                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M9 5L15 12L9 19" stroke="currentColor" stroke-width="1.5"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </div>
                            </button>
                            <ul x-cloak x-show="activeDropdown === 'inputnilaisikap'" x-collapse class="sub-menu text-gray-500">
                                <li>
                                    <a href="{{ route('nilai-sikap-spiritual.index') }}">Input Nilai Sikap Spiritual</a>
                                </li>
                            </ul>
                            <ul x-cloak x-show="activeDropdown === 'inputnilaisikap'" x-collapse class="sub-menu text-gray-500">
                                <li>
                                    <a href="{{ route('nilai-sikap-sosial.index') }}">Input Nilai Sikap Sosial</a>
                                </li>
                            </ul>
                            @endif
                        </li> --}}
                        <li class="menu nav-item">
                            <a href="{{ route('absen.index') }}" class="nav-link group">
                                <div class="flex items-center">

                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Absensi</span>
                                </div>
                            </a>
                        </li>

                        <li class="menu nav-item">
                            <a href="{{ route('cetak-legger-wali.index',$mappingWaliKelas->kelas_id) }}" class="nav-link group">
                                <div class="flex items-center">

                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Cetak Legger</span>
                                </div>
                            </a>
                        </li>

                        @if ($mappingWaliKelas->kelas->tingkatan->kode_tingkatan === 'XII')
                        <li class="menu nav-item">
                            <a href="{{ route('prakerin.index') }}" class="nav-link group">
                                <div class="flex items-center">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Nilai Prakerin</span>
                                </div>
                            </a>
                        </li>
                        @endif

                        <li class="menu nav-item">
                            <a href="{{ route('nilai-ekskul.index') }}" class="nav-link group">
                                <div class="flex items-center">
                                   <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>
                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Nilai Ekstrakurikuler</span>
                                </div>
                            </a>
                        </li>

                        <li class="menu nav-item">
                            <a href="{{ route('prestasi.index') }}" class="nav-link group">
                                <div class="flex items-center">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>
                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Nilai Prestasi</span>
                                </div>
                            </a>
                        </li>

                        <li class="menu nav-item">
                            <a href="{{ route('catatan.index') }}" class="nav-link group">
                                <div class="flex items-center">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M21 16C21 18.8284 21 20.2426 20.1213 21.1213C19.2426 22 17.8284 22 15 22H9C6.17157 22 4.75736 22 3.87868 21.1213C3 20.2426 3 18.8284 3 16V8C3 5.17157 3 3.75736 3.87868 2.87868C4.75736 2 6.17157 2 9 2H15C17.8284 2 19.2426 2 20.1213 2.87868C21 3.75736 21 5.17157 21 8V12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M8 2V6M8 22V10" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 12H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 16H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M2 8H4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 6.5H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M11.5 10H16.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"></path>
                                    </svg>

                                    <span class="ltr:pl-3 rtl:pr-3 text-black dark:text-[#506690] dark:group-hover:text-white-dark">Input Nilai Catatan Kenaikan</span>
                                </div>
                            </a>
                        </li>
                        @endif

                    @endif
                @endif

                <!-- End Menu Sidebar -->
            </ul>
        </div>
    </nav>
</div>
<script>
    document.addEventListener("alpine:init", () => {
        Alpine.data("sidebar", () => ({
            init() {
                const selector = document.querySelector('.sidebar ul a[href="' + window.location
                    .pathname + '"]');
                if (selector) {
                    selector.classList.add('active');
                    const ul = selector.closest('ul.sub-menu');
                    if (ul) {
                        let ele = ul.closest('li.menu').querySelectorAll('.nav-link');
                        if (ele) {
                            ele = ele[0];
                            setTimeout(() => {
                                ele.click();
                            });
                        }
                    }
                }
            },
        }));
    });
</script>
