<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('cetak-sampul-raport.index') }}" class="text-primary hover:underline">Admin</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Cetak Raport</span>
        </li>
    </ul>

    <div>
        <div class="panel mt-6">
            <div class="grid grid-cols-3 gap-3">
                <h5 class="font-semibold text-lg dark:text-white-light">Cetak Raport</h5>
            </div>

            <label for="kelas" class="mt-5">
                    Pilih Kelas
            </label>

            <div class="grid grid-cols-2 ">
                <form action="{{route('cetak-sampul-raport.index')}}" method="GET">
                    <select name="kelas" class="form-input">
                            <option disabled selected>Pilih Kelas</option>
                        @foreach($kelas as $data)
                            <option @if($data->id == request()->kelas) selected @endif value="{{$data->id}}">{{$data->nama_kelas}}</option>
                        @endforeach
                    </select>

                    @php
                        $reqKelas = request()->get('kelas');
                    @endphp
                    @if(isset($reqKelas))
                        <div class="mt-2">
                            <p class="text-md">Kelas yang dipilih: <span class="font-bold">{{ \App\Models\Kelas::find($reqKelas)->nama_kelas }}</span></p>
                        </div>
                    @endif

                    <button type="submit" class="btn btn-primary mt-5">Pilih Kelas</button>
                </form>
            </div>


            <div class="py-11">
                <div class="overflow-x-auto">
                    <table class="table-auto min-w-full divide-y">
                        @php
                            $i = 1;
                        @endphp
                        <thead>
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">No</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cetak</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($mappingSiswa as $data)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap">{{$i++}}</td>
                                <td class="px-6 py-4 whitespace-nowrap">{{$data->siswa->nama_siswa}}</td>
                                <td class="px-6 py-4 whitespace-nowrap">@include('cetak-sampul-raport.table-actions')</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>


        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
