<x-layout.default>

    <ul class="flex space-x-2 rtl:space-x-reverse">
        <li>
            <a href="{{ route('absensi-raport.absensi') }}" class="text-primary hover:underline">Cetak Absensi</a>
        </li>
        <li class="before:content-['/'] ltr:before:mr-1 rtl:before:ml-1">
            <span>Cetak Absensi</span>
        </li>
    </ul>

    <div>
        <div class="panel mt-6">
            <div class="grid grid-cols-3 gap-3">
                <h5 class="font-semibold text-lg dark:text-white-light">Cetak Absensi Raport</h5>
            </div>

            <label for="kelas" class="mt-5">
                    Pilih Kelas
            </label>

            <div class="grid grid-cols-2 ">
                <form action="{{route('cetak-absensi-raport.absensi')}}" method="POST">
                    @csrf
                    <select name="kelas" class="form-input">
                            <option disabled selected>Pilih Kelas</option>
                        @foreach($kelas as $data)
                            <option @if($data->id == request()->kelas) selected @endif value="{{$data->id}}">{{$data->nama_kelas}}</option>
                        @endforeach
                    </select>

                    @php
                        $reqKelas = request()->get('kelas');
                    @endphp
                    @if(isset($reqKelas))
                        <div class="mt-2">
                            <p class="text-md">Kelas yang dipilih: <span class="font-bold">{{ \App\Models\Kelas::find($reqKelas)->nama_kelas }}</span></p>
                        </div>
                    @endif

                    <button type="submit" class="btn btn-primary mt-5">Cetak</button>
                </form>
            </div>



        </div>
    </div>

    <script>
        document.addEventListener("alpine:init", () => {
            Alpine.data("dropdown", (initialOpenState = false) => ({
                open: initialOpenState,

                toggle() {
                    this.open = !this.open;
                },
            }));
        });
    </script>

</x-layout.default>
