<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nilai_sikap_spiritual', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('tahun_ajaran_id')->unsigned();
            $table->bigInteger('mapping_walikelas_id')->unsigned();
            $table->bigInteger('siswa_id')->unsigned();
            $table->bigInteger('kelas_id')->unsigned();
            $table->bigInteger('master_nilai_sikap_id')->unsigned();
            $table->foreign('tahun_ajaran_id')->references('id')->on('tahun_ajarans')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('mapping_walikelas_id')->references('id')->on('mapping_wali_kelas')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('siswa_id')->references('id')->on('siswa')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('kelas_id')->references('id')->on('kelas')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('master_nilai_sikap_id')->references('id')->on('master_nilai_sikap')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->boolean('status');
            $table->enum('type',['selalu','mulai_meningkat']);
            $table->integer('semester');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nilai_sikap_spiritual');
    }
};
