<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('nilai_pts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('tahun_ajaran_id')->unsigned();
            $table->bigInteger('mapping_guru_id')->unsigned();
            $table->bigInteger('siswa_id')->unsigned();
            $table->bigInteger('kelas_id')->unsigned();
            $table->foreign('tahun_ajaran_id')->references('id')->on('tahun_ajarans')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('mapping_guru_id')->references('id')->on('mapping_guru')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('siswa_id')->references('id')->on('siswa')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign('kelas_id')->references('id')->on('kelas')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->integer('nilai');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('nilai_pts');
    }
};
