<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Lab404\Impersonate\Models\Impersonate;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Support\Str;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles, Impersonate;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // Model
    protected static function booted(): void
    {
        static::creating(function (User $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }

    public function userable()
    {
        return $this->morphTo(__FUNCTION__, 'model_type', 'model_id');
    }

    public static function storeUserable($fill, Userable $model): Model
    {
        $user = $model->user()->firstOrNew(['model_type' => get_class($model), 'model_id' => $model->id]);
        foreach ($model->syncedAttributes() as $from => $to) {
            $user->$from = $model->$to;
        }
        $user->fill($fill);
        $user->password = isset($fill['password'])? bcrypt($fill['password']): bcrypt('default');
        $user->email_verified_at = time();
        $user->remember_token = Str::random(10);
        $user->save();
        return $user;
    }


}
