<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NilaiSikapSpiritual extends Model
{
    use HasFactory;
    protected $table = 'nilai_sikap_spiritual';
    protected $fillable = ['tahun_ajaran_id','mapping_walikelas_id','kelas_id','siswa_id','master_nilai_sikap_id','status','type','semester'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapping_walikelas()
    {
        return $this->belongsTo(MappingWaliKelas::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }
    public function master_nilai_sikap()
    {
        return $this->belongsTo(MasterNilaiSikap::class);
    }
}
