<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NilaiPas extends Model
{
    use HasFactory;
    protected $table = 'nilai_pas';
    protected $fillable = ['tahun_ajaran_id','mapping_guru_id', 'semester', 'siswa_id','nilai','jenis'];
    protected const jenis = ['PAS','PAT'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapping_guru()
    {
        return $this->belongsTo(MappingGuru::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
}
