<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class MappingWaliKelas extends Model
{
    use HasFactory;
    protected $table = "mapping_wali_kelas";
    protected $fillable = ["guru_id","tahun_ajaran_id","kelas_id"];

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }
    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function absen()
    {
        return $this->hasMany(Absen::class);
    }
    public function nilai_ekskul()
    {
        return $this->hasMany(NilaiEkstrakulikuler::class);
    }
    public function catatan()
    {
        return $this->hasMany(Catatan::class);
    }
    public function prakerin()
    {
        return $this->hasMany(NilaiPrakerin::class);
    }
    public function nilaisikapsosial()
    {
        return $this->hasMany(NilaiSikapSosial::class);
    }
    public function nilaisikapspiritual()
    {
        return $this->hasMany(NilaiSikapSpiritual::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (MappingWaliKelas $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }
}
