<?php

namespace App\Models;

use App\Models\Guru;
use App\Models\Mapel;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class MappingGuru extends Model
{
    use HasFactory;

    protected $table = 'mapping_guru';

    protected $fillable = ['guru_id', 'mapel_id', 'kelas_id', 'tahun_ajaran_id'];

    public function guru()
    {
        return $this->belongsTo(Guru::class);
    }

    public function mapel()
    {
        return $this->belongsTo(Mapel::class);
    }

    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }

    public function nilai_pengetahuan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_keterampilan()
    {
        return $this->hasMany(NilaiPengetahuan::class);
    }

    public function nilai_pts()
    {
        return $this->hasMany(NilaiPts::class);
    }

    public function nilai_pas()
    {
        return $this->hasMany(NilaiPas::class);
    }

}


