<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;


class Kelas extends Model
{
    use HasFactory;

    protected $fillable = [
        'jurusan_id',
        'kode_kelas',
        'tingkatan_id',
        'nama_kelas',
        'deskripsi'
    ];

    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class);
    }

    public function tingkatan()
    {
        return $this->belongsTo(Tingkatan::class);
    }

    // public function siswakelastahunajaran()
    // {
    //     return $this->hasMany(SiswaKelasTahunAjaran::class, 'siswakelastahunajaran_id');
    // }

    // public function homevisit()
    // {
    //     return $this->hasMany(HomeVisit::class);
    // }
    public function absen()
    {
        return $this->hasMany(Absen::class);
    }
    public function nilai_ekskul()
    {
        return $this->hasMany(NilaiEkstrakulikuler::class);
    }
    public function catatan()
    {
        return $this->hasMany(Catatan::class);
    }
    public function prakerin()
    {
        return $this->hasMany(NilaiPrakerin::class);
    }
    public function nilaisikapsosial()
    {
        return $this->hasMany(NilaiSikapSosial::class);
    }
    public function nilaisikapspiritual()
    {
        return $this->hasMany(NilaiSikapSpiritual::class);
    }

    // Model
    protected static function booted(): void
    {
        static::creating(function (Kelas $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }
}


