<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Guru extends Model implements Userable
{
    use HasFactory, SoftDeletes;
    protected $table = 'guru';

    protected $fillable = ['uuid','gambar','nip','nik', 'tanggal_lahir','jenis_kelamin'
        ,'jabatan','agama','npsn','alamat_sekolah','nama_lengkap','nuptk','tempat_lahir',
        'tanggal_lahir','nama_ibu_kandung','no_hp','email','alamat_guru','status_perkawinan','status_sekolah','nama_suami_istri'
        ,'pekerjaan_suami_istri','status_kepegawaian','tmt_awal','lama_bertugas','bidang_studi','jenjang_pendidikan'
        ,'gelar_akademik','satuan_pendidikan_formal','tahun_masuk','tahun_lulus','nim'];

    public function mappingWaliKelas()
    {
        return $this->hasMany(MappingWaliKelas::class);
    }

    public function homevisit()
    {
        return $this->hasMany(HomeVisit::class);
    }

    public function list_kd()
    {
        return $this->belongsTo(ListKd::class);
    }

    protected static function booted(): void
    {
        static::creating(function (Guru $model) {
            $model->uuid = Str::uuid()->toString();
        });
    }

    public function user(): MorphOne
    {
        return $this->morphOne(User::class, 'model');
    }

    public function syncedAttributes(): array
    {
        return [
            'email' => 'email',
            'name' => 'nama_lengkap'
        ];
    }

    public function document()
    {
        return $this->morphMany(Document::class, 'owner');
    }
}
