<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Absen extends Model
{
    use HasFactory;
    protected $table = 'absen';
    protected $fillable = ['tahun_ajaran_id','mapping_walikelas_id','kelas_id','siswa_id','izin','sakit','tanpa_keterangan','semester'];

    public function tahunAjaran()
    {
        return $this->belongsTo(TahunAjaran::class);
    }
    public function mapping_walikelas()
    {
        return $this->belongsTo(MappingWaliKelas::class);
    }
    public function siswa()
    {
        return $this->belongsTo(Siswa::class);
    }
    public function kelas()
    {
        return $this->belongsTo(Kelas::class);
    }
}
