<?php

namespace App\Http\Services;

use App\Models\Kelas;
use App\Models\Mapel;
use App\Models\MappingGuru;
use App\Models\MappingSiswa;
use App\Models\NilaiKeterampilan;
use App\Models\NilaiPas;
use App\Models\NilaiPengetahuan;
use App\Models\NilaiPts;
use App\Models\RateNilai;
use App\Models\Semester;
use App\Models\Siswa;
use App\Models\TahunAjaran;
use Illuminate\Support\Collection;

class LeggerService {
    protected TahunAjaran $tahunAjaran;
    protected Kelas $kelas;
    protected Semester $semester;
    protected RateNilai $rateNilai;
    protected $result;
    protected $listSiswa;

    public function __construct($tahunAjaran, $kelas, $semester, $rateNilai)
    {
        $this->tahunAjaran = $tahunAjaran;
        $this->kelas = $kelas;
        $this->semester = $semester;
        $this->rateNilai = $rateNilai;
    }

    public function generate()
    {
        // TODO: Generate List Siswa
        $this->listSiswa = $this->getListSiswa();
        // TODO: Generate List Mapel
        $this->listSiswa = $this->getListMapel($this->listSiswa);
        // TODO: Generate Nilai Pengetahuan & Keterampilan
        $this->result = $this->calculateNilai($this->listSiswa);

        return $this->result;
    }

    public function getListSiswa(): Collection
    {
        $mappingSiswa = MappingSiswa::where('tahun_ajaran_id', $this->tahunAjaran->id)
            ->where('kelas_id', $this->kelas->id)
            ->get();

        $listSiswa = [];

        foreach($mappingSiswa as $key => $siswa){
            $listSiswa[$key]['nama'] = $siswa->siswa->nama_siswa;
            $listSiswa[$key]['mapping_siswa_id'] = $siswa->siswa_id;
        }
        return collect($listSiswa);
    }

    public function getListMapel(Collection $listSiswa): Collection
    {
        $kelasMapel = MappingGuru::where('kelas_id', $this->kelas->id)
            ->where('tahun_ajaran_id', $this->tahunAjaran->id)
            ->get();

        $listMapel = [];

        foreach($listSiswa as $key => $value){
            foreach($kelasMapel as $mappingMapel){
                $listMapel[$value['mapping_siswa_id']]["nama"] = $value['nama'];
                $listMapel[$value['mapping_siswa_id']]["mapping_siswa_id"] = $value['mapping_siswa_id'];
                $listMapel[$value['mapping_siswa_id']]["nilai"][$mappingMapel->mapel->kode_mapel] = [
                    'nama_mapel' => $mappingMapel->mapel->nama_mapel,
                    'pengetahuan' => 0,
                    'keterampilan' => 0,
                ];
            }
        }

        return collect($listMapel);
    }

    public function calculateNilai(Collection $listSiswa): Collection
    {
        $result = [];

        // Get All Siswa Nilai by Jenis
        $siswaIds = MappingSiswa::where('tahun_ajaran_id', $this->tahunAjaran->id)
            ->where('kelas_id', $this->kelas->id)
            ->pluck('siswa_id')->toArray();

        $nilaiPengetahuan = NilaiPengetahuan::where('tahun_ajaran_id', $this->tahunAjaran->id)
            ->where('semester', $this->semester->kode)
            ->whereIn('siswa_id', $siswaIds)
            ->get();

        $nilaiKeterampilan = NilaiKeterampilan::where('tahun_ajaran_id', $this->tahunAjaran->id)
            ->where('semester', $this->semester->kode)
            ->whereIn('siswa_id', $siswaIds)
            ->get();

        // Calculate Nilai Siswa by Jenis
        $siswaWithNilai = [];

        foreach($nilaiPengetahuan as $np){
            if($np->siswa_id === $listSiswa[$np->siswa_id]['mapping_siswa_id']){
                $siswaWithNilai[$np->siswa_id]['NP'][] = $np;
            }
        }

        foreach($nilaiKeterampilan as $nk){
            if($nk->siswa_id === $listSiswa[$nk->siswa_id]['mapping_siswa_id']){
                $siswaWithNilai[$nk->siswa_id]['NK'][] = $nk;
            }
        }



        $siswaWithCalculatedNilai = [];
        foreach($siswaWithNilai as $siswaId => $value){

            if(array_key_exists('NP', $value)){
                foreach($value['NP'] as $nilai){
                    $mappingGuru = MappingGuru::find($nilai['mapping_guru_id']);
                    $kodeMapel = $mappingGuru->mapel->kode_mapel;
                    $siswaWithCalculatedNilai[$siswaId][$kodeMapel]['NP'][] = $nilai['nilai'];
                    $siswaWithCalculatedNilai[$siswaId][$kodeMapel]['mapping_guru_id'] = $nilai['mapping_guru_id'];
                }
            }

            if(array_key_exists('NK', $value)) {
                foreach($value['NK'] as $nilai){
                    $mappingGuru = MappingGuru::find($nilai['mapping_guru_id']);
                    $kodeMapel = $mappingGuru->mapel->kode_mapel;
                    $siswaWithCalculatedNilai[$siswaId][$kodeMapel]['NK'][] = $nilai['nilai'];
                    $siswaWithCalculatedNilai[$siswaId][$kodeMapel]['mapping_guru_id'] = $nilai['mapping_guru_id'];
                }
            }
        }
        $siswaWithFinalNilai = [];
        foreach($siswaWithCalculatedNilai as $siswaId => $mapel){
            foreach($mapel as $kodeMapel => $nilaiMapel){
                $nilaiPts = NilaiPts::where('semester', $this->semester->kode)
                    ->where('siswa_id', $siswaId)
                    ->where('mapping_guru_id', $nilaiMapel['mapping_guru_id'])
                    ->first();
                $nilaiPas = NilaiPas::where('semester', $this->semester->kode)
                    ->where('siswa_id', $siswaId)
                    ->where('mapping_guru_id', $nilaiMapel['mapping_guru_id'])
                    ->first();

                if($nilaiMapel['NP']){
                    $nilaiPengetahuan = (int) number_format(array_sum($nilaiMapel['NP']) / count($nilaiMapel['NP']), 0);
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['NP'] = $this->calculateAverageNilaiWithRate($nilaiPengetahuan, 'NH');
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['PTS'] = $this->calculateAverageNilaiWithRate($nilaiPts->nilai ?? 0, 'PTS');
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['PAS'] = $this->calculateAverageNilaiWithRate($nilaiPas->nilai ?? 0, 'PAS');
                }

                if($nilaiMapel['NK']){
                    $nilaiPengetahuan = (int) number_format(array_sum($nilaiMapel['NK']) / count($nilaiMapel['NK']), 0);
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['NK'] = $this->calculateAverageNilaiWithRate($nilaiPengetahuan, 'NH');
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['PTS'] = $this->calculateAverageNilaiWithRate($nilaiPts->nilai ?? 0, 'PTS');
                    $siswaWithFinalNilai[$siswaId][$kodeMapel]['PAS'] = $this->calculateAverageNilaiWithRate($nilaiPas->nilai ?? 0, 'PAS');
                }
            }
        }

        $this->result = [];
        foreach($siswaWithFinalNilai as $siswaId => $nilai){
            foreach($nilai as $kodeMapel => $jenis){
                $siswa = Siswa::find($siswaId);
                $this->result[$siswaId]['nama'] = $siswa->nama_siswa;
                $this->result[$siswaId]['nilai'][$kodeMapel]['NP'] = number_format($jenis['NP'] + $jenis['PTS'] + $jenis['PAS'], 0);
                $this->result[$siswaId]['nilai'][$kodeMapel]['NK'] = number_format($jenis['NK'] + $jenis['PTS'] + $jenis['PAS'], 0);
            }
        }

        return collect($this->result)->sortBy('nama');
    }

    public function calculateAverageNilaiWithRate(int $nilai, string $type): int
    {
        $rasio = RateNilai::where('is_active', 1)
        ->first();
        $calculatedNilai = 0;
        switch ($type){
            case 'NH': $calculatedNilai = ($nilai * $this->rateNilai->rate_nilai_harian) / 100; break;
            case 'PTS': $calculatedNilai = ($nilai * $this->rateNilai->rate_pts) / 100; break;
            case 'PAS': $calculatedNilai = ($nilai * $this->rateNilai->rate_pas) / 100; break;
        }
        return number_format($calculatedNilai, 0);
    }
}
