<?php

namespace App\Http\Livewire;

use App\Models\MappingGuru as ModelsMappingGuru;
use Illuminate\Support\Facades\Auth;
use Mediconesystems\LivewireDatatables\Column;
use Mediconesystems\LivewireDatatables\Http\Livewire\LivewireDatatable;

class MapelDiampuTable extends LivewireDatatable
{
    public $model = ModelsMappingGuru::class;

    public function builder()
    {
        return ModelsMappingGuru::select('mapel_id')->distinct()->where('guru_id',Auth::user()->model_id);
    }

    public function columns()
    {
        return [
            Column::index($this),
            Column::name('mapel.nama_mapel')->label('Nama Mapel')->searchable(),
            Column::name('tahunAjaran.nama_tahun_ajaran')->label('Tahun Ajaran'),
            Column::callback(['mapel_id'], function ($mapel_id) {
                return view('mapel-diampu.table_action', ['mapel_id' => $mapel_id]);
            })->unsortable()

        ];
    }
}
