<?php

namespace App\Http\Controllers;

use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\NilaiPrestasi;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NilaiPrestasiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('prestasi.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $wali = MappingWaliKelas::where('guru_id',Auth::user()->model_id)
                                ->where('tahun_ajaran_id',$tahun_ajaran->id)->first();
        $siswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
                                ->where('mapping_siswa.kelas_id', $wali->kelas->id)
                                ->where('mapping_siswa.tahun_ajaran_id', $tahun_ajaran->id)
                                ->select('mapping_siswa.*', 'siswa.nama_siswa')
                                ->orderBy('siswa.nama_siswa', 'ASC')
                                ->get();
        return view('prestasi.create',compact('siswa','wali'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'kelas_id' => 'required|integer',
            'siswa_id' => 'required|integer',
            'jenis' => 'required|string',
            'keterangan' => 'required|string',
        ]);
        $data = new NilaiPrestasi();
        $data->kelas_id = $request->kelas_id;
        $data->siswa_id = $request->siswa_id;
        $data->jenis = $request->jenis;
        $data->keterangan = $request->keterangan;
        $data->save();
        return redirect()->route('prestasi.index')->with('sukses','Prestasi berhasil disimpan');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $wali = MappingWaliKelas::where('guru_id',Auth::user()->model_id)->first();
        $siswa = MappingSiswa::where('kelas_id',$wali->kelas_id)->get();
        $prestasi = NilaiPrestasi::find($id);
        return view('prestasi.edit',compact('siswa','wali','prestasi'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'kelas_id' => 'required|integer',
            'siswa_id' => 'required|integer',
            'jenis' => 'required|string',
            'keterangan' => 'required|string',
        ]);
        $data = NilaiPrestasi::find($id);
        $data->kelas_id = $request->kelas_id;
        $data->siswa_id = $request->siswa_id;
        $data->jenis = $request->jenis;
        $data->keterangan = $request->keterangan;
        $data->save();
        return redirect()->route('prestasi.index')->with('sukses','Prestasi berhasil disimpan');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $data = NilaiPrestasi::find($id);
        $data->delete();

        return redirect()
            ->back()
            ->with('sukses', "Prestasi berhasil dihapus");

    }
}
