<?php

namespace App\Http\Controllers;

use App\Imports\NilaiImport;
use App\Models\MappingSiswa;
use App\Models\NilaiPas;
use App\Models\NilaiPts;
use App\Models\Semester;
use App\Models\Siswa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class NilaiPasController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $kelas = $request->kelas_id;
        $mapping_guru = $request->mapping_guru_id;
        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapel = $request->mapel_id;

        $mapping_siswa = MappingSiswa::join('siswa', 'mapping_siswa.siswa_id', '=', 'siswa.id')
            ->where('mapping_siswa.kelas_id', $kelas)
            ->where('mapping_siswa.tahun_ajaran_id', $tahun_ajaran)
            ->select('mapping_siswa.*', 'siswa.nama_siswa')
            ->orderBy('siswa.nama_siswa', 'ASC')
            ->get();
        $semester = Semester::where('is_active',1)->first();
        $nilai_pas = NilaiPas::where('kelas_id',$kelas)->where('semester',$semester->kode)->get();
        return view('nilai-pas.index',compact('mapel','nilai_pas','mapping_siswa','kelas','mapping_guru','tahun_ajaran'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'tahun_ajaran_id' => 'required|integer',
            'mapping_guru_id' => 'required|integer',
            'kelas_id' => 'required|integer',
        ]);

        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapping_guru = $request->mapping_guru_id;
        $kelas = $request->kelas_id;

        foreach ($request->siswa as $key => $value) {
            $nilaisiswa = implode(',', $value);

            $siswa = $key;
            $nilai = $nilaisiswa;

            NilaiPas::updateOrInsert(
                [
                    'siswa_id' => $siswa,
                    'tahun_ajaran_id' => $tahun_ajaran,
                    'mapping_guru_id' => $mapping_guru,
                    'kelas_id' => $kelas,
                    'jenis' => 'PAS',
                    'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                ],
                [
                    'nilai' => $nilai,
                ]
            );
        }


        return redirect()->back()->with('sukses','Nilai berhasil disimpan');
    }

    public function import(Request $request)
    {
        $data = Excel::toCollection(new NilaiImport, $request->file('file'));
        try {
            DB::beginTransaction();
            foreach($data[0] as $key => $value){
                // Skip header
                if(!is_string($value[0])){
                    $siswa = Siswa::where('nama_siswa', $value[1])
                        ->whereHas('mappingSiswa', function($query) use ($request){
                            return $query->where('kelas_id', $request->kelas_id)
                                ->where('tahun_ajaran_id', $request->tahun_ajaran_id);
                        })
                        ->first();

                    if($siswa == null){
                        throw new \Exception('Terdapat siswa yang tidak sesuai dengan kelas yang dipilih!');
                    }

                    $nilai = (int) number_format($value[2], 0);

                    if($nilai < 0 || $nilai > 100){
                        throw new \Exception('Nilai harus diantara rentang 0 sampai dengan 100');
                    }

                    if($siswa !== null){
                        NilaiPas::updateOrInsert(
                            [
                                'siswa_id' => $siswa->id,
                                'tahun_ajaran_id' => $request->tahun_ajaran_id,
                                'mapping_guru_id' => $request->mapping_guru_id,
                                'kelas_id' => $request->kelas_id,
                                'jenis' => 'PAS',
                                'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                            ],
                            [
                                'nilai' => $nilai,
                            ]
                        );
                    }
                }
            }
            DB::commit();

        } catch(\Exception $e){
            DB::rollBack();
            return redirect()->back()->with('fail', 'Terdapat kesalahan! '.$e->getMessage());
        }
        return redirect()->back()->with('sukses','Nilai berhasil diimport!');
    }


}
