<?php

namespace App\Http\Controllers;

use App\Models\ListKd;
use App\Models\Mapel;
use App\Models\MappingGuru;
use App\Models\MasterKd;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class MasterKdController extends Controller
{

    /**
     * Show the form for creating a new resource.
     */
    public function create(Request $request)
    {
        $mapel_id = $request->mapel_id;
        $tahun_ajaran = TahunAjaran::get();
        $mapel = MappingGuru::select('mapel_id')->distinct('mapel_id')->where('guru_id',Auth::user()->model_id)->get();
        return view('master_kd.create',compact('tahun_ajaran','mapel','mapel_id'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'mapel_id' => 'required',
            'tahun_ajaran_id' => 'required',
            'kode_kd' => [
                'required',
                'string',
                Rule::unique('master_kd','kode_kd')->where('mapel_id',$request->input('mapel_id')),
            ],
            'nama_kd' => 'required|string',
            'keterangan' => 'nullable|string',
            'jenis_kd' => 'required|string',
        ]);
        $mapel = $request->mapel_id;
        $tahun_ajaran_id = $request->tahun_ajaran_id;
        $data = new MasterKd();
        $data->mapel_id = $request->mapel_id;
        $data->tahun_ajaran_id = $request->tahun_ajaran_id;
        $data->kode_kd = $request->kode_kd;
        $data->nama_kd = $request->nama_kd;
        $data->keterangan = $request->keterangan;
        $data->jenis_kd = $request->jenis_kd;
        $data->save();

        return redirect()->route('mapel-diampu.show',[
            "id" => $mapel,
            "tahun_ajaran_id" => $tahun_ajaran_id
        ])->with('sukses', 'Berhasil Menambahkan Data');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $master_kd = MasterKd::find($id);
        $tahun_ajaran = TahunAjaran::get();
        $mapel = Mapel::all();
        return view('master_kd.show', compact('master_kd','tahun_ajaran','mapel'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $master_kd = MasterKd::find($id);
        $tahun_ajaran = TahunAjaran::all();
        $mapel = MappingGuru::select('mapel_id')->distinct('mapel_id')->where('guru_id',Auth::user()->model_id)->get();
        return view('master_kd.edit',compact('tahun_ajaran','master_kd','mapel'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'mapel_id' => 'required',
            'tahun_ajaran_id' => 'required',
            'kode_kd' => [
                'required',
                'string',
                Rule::unique('master_kd','kode_kd')->where('mapel_id',$request->input('mapel_id'))->ignore($id),
            ],
            'nama_kd' => 'required|string',
            'keterangan' => 'nullable|string',
            'jenis_kd' => 'required|string',
        ]);

        $mapel = $request->mapel_id;
        $tahun_ajaran_id = $request->tahun_ajaran_id;
        $data = MasterKd::find($id);
        $data->mapel_id = $request->mapel_id;
        $data->tahun_ajaran_id = $request->tahun_ajaran_id;
        $data->kode_kd = $request->kode_kd;
        $data->nama_kd = $request->nama_kd;
        $data->keterangan = $request->keterangan;
        $data->jenis_kd = $request->jenis_kd;
        $data->save();

        $list_kd = ListKd::where('kode_kd',$data->kode_kd)->first();
        if ($list_kd->count() > 0) {
            $list_kd->tahun_ajaran_id = $data->tahun_ajaran_id;
            $list_kd->nama_kd = $data->nama_kd;
            $list_kd->jenis_kd = $data->jenis_kd;
            $list_kd->save();
        }

        return redirect()->route('mapel-diampu.show',[
            "id" => $mapel,
            "tahun_ajaran_id" => $tahun_ajaran_id
        ])->with('sukses', 'Berhasil Mengubah Data');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $data = MasterKd::find($id);
        $data->delete();
        return redirect()->back()->with([
            'sukses' => "Kd berhasil dihapus",
        ]);
    }
}
