<?php

namespace App\Http\Controllers;

use App\Models\MasterEkskul;
use Illuminate\Http\Request;

class MasterEkskulController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('master-ekskul.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('master-ekskul.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama_ekskul' => 'required|string',
            'deskripsi' => 'required|string'
        ]);
        $data = new MasterEkskul();
        $data->nama_ekskul = $request->nama_ekskul;
        $data->deskripsi = $request->deskripsi;
        $data->save();

        return redirect()->route('master-ekskul.index')->with([
            'sukses' => "Master ekskul berhasil ditambahkan",
        ]);
    }

    
    public function edit(string $id)
    {
        $master_ekskul = MasterEkskul::find($id);
        return view('master-ekskul.edit',compact('master_ekskul'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'nama_ekskul' => 'required|string',
            'deskripsi' => 'required|string'
        ]);

        $data = MasterEkskul::find($id);
        $data->nama_ekskul = $request->nama_ekskul;
        $data->deskripsi = $request->deskripsi;
        $data->save();

        return redirect()->route('master-ekskul.index')->with([
            'sukses' => "Master ekskul berhasil diubah",
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $data = MasterEkskul::find($id);
        $data->delete();

        return redirect()
            ->back()
            ->with('sukses', "Master ekskul berhasil dihapus");

    }
}
