<?php

namespace App\Http\Controllers;

use App\Models\Mapel;
use App\Models\MappingGuru;
use App\Models\MasterKd;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MapelDiampuController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        if(!Auth::check()){
            return redirect()->route('login.index')->with('gagal', 'Sesi anda telah berakhir! silahkan login kembali');
        }

        $mapel = MappingGuru::select('mapel_id','tahun_ajaran_id')->distinct('mapel_id','tahun_ajaran_id')->where('guru_id',Auth::user()->model_id)->get();

        return view('mapel-diampu.index',compact('mapel'));
    }


    public function show(string $id, Request $request)
    {
        if(!Auth::check()){
            return redirect()->route('login.index')->with('gagal', 'Sesi anda telah berakhir! silahkan login kembali');
        }

        $mapel_id = $request->id;
        $tahun_ajaran_id = $request->tahun_ajaran_id;
        $mapping_guru = MappingGuru::where('mapel_id',$id)->where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id',$tahun_ajaran_id)->get();
        $sort_jenis_kd = $request->input('sort_jenis_kd');
        if (isset($sort_jenis_kd)) {
            $masterkd = MasterKd::where('mapel_id',$id)->where('jenis_kd','like',$sort_jenis_kd)->paginate(10);
            $mapping_guru = MappingGuru::where('mapel_id',$id)->where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id',$tahun_ajaran_id)->get();
        } else {
            $masterkd = MasterKd::where('mapel_id',$id)->paginate(10);
            $mapping_guru = MappingGuru::where('mapel_id',$id)->where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id',$tahun_ajaran_id)->get();
        }


        $mapel = Mapel::find($id);
        return view('mapel-diampu.show',compact('mapping_guru','masterkd', 'mapel', 'mapel_id'));
    }

}
