<?php

namespace App\Http\Controllers;

use App\Models\ListKd;
use App\Models\MasterKd;
use App\Models\Semester;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;

class ListKdController extends Controller
{

    public function store(Request $request)
    {
        $idmapel = $request->mapel_id;
        $tingkat = $request->tingkat;
        $master = $request->kode_kd;
        $activeSemester = Semester::where('is_active', true)->first();

        $request->validate([
            'kode_kd' => [
                Rule::unique('list_kd','kode_kd')->where('mapel_id',$idmapel)->where('tingkat',$tingkat)->where('guru_id',Auth::user()->model_id)->where('tahun_ajaran_id',TahunAjaran::where('is_active',1)->first()->id),
            ]
        ]);

        $masterkd = MasterKd::where('kode_kd',$master)->where('mapel_id',$idmapel)->first();

        $data = new ListKd();
        $data->mapel_id = $masterkd->mapel_id;
        $data->tahun_ajaran_id = TahunAjaran::where('is_active',1)->first()->id;
        $data->guru_id = Auth::user()->model_id;
        $data->kode_kd = $masterkd->kode_kd;
        $data->nama_kd = $masterkd->nama_kd;
        $data->jenis_kd = $masterkd->jenis_kd;
        $data->tingkat = $tingkat;
        $data->semester = $activeSemester->kode;
        $data->save();

        return redirect()->back()->with([
            'sukses' => "Kd berhasil ditambahkan",
        ]);
    }


    public function destroy(string $id, Request $request)
    {
        $data = ListKd::find($id);
        $data->delete();

        return redirect()
            ->back()
            ->with('sukses', "Kd berhasil dihapus");
    }
}
