<?php

namespace App\Http\Controllers;

use App\Models\Absen;
use App\Models\MappingSiswa;
use App\Models\MappingWaliKelas;
use App\Models\Semester;
use App\Models\TahunAjaran;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AbsenController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $tahun_ajaran = TahunAjaran::where('is_active',1)->first();
        $mapping_walikelas = MappingWaliKelas::where('guru_id',Auth::user()->model_id)
                                             ->where('tahun_ajaran_id',$tahun_ajaran->id)->first();

        $semester = Semester::where('is_active',1)->first();
        $mapping_siswa = MappingSiswa::where('kelas_id',$mapping_walikelas->kelas_id)
                                     ->where('tahun_ajaran_id',$tahun_ajaran->id)->get();
        $absen = Absen::where('kelas_id',$mapping_walikelas->kelas_id)
                                     ->where('semester',$semester->kode)
                                     ->where('tahun_ajaran_id',$tahun_ajaran->id)->get();
        return view('absen.index',compact('absen','mapping_siswa','mapping_walikelas','tahun_ajaran'));
    }

    /**
     * Show the form for creating a new resource.
     */

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'tahun_ajaran_id' => 'required|integer',
            'mapping_walikelas_id' => 'required|integer',
            'kelas_id' => 'required|integer',
            'siswa' => 'required|array',
            'siswa.*.izin' => 'required|integer|between:0,30',
            'siswa.*.sakit' => 'required|integer|between:0,30',
            'siswa.*.tanpa_keterangan' => 'required|integer|between:0,30',
        ]);

        $tahun_ajaran = $request->tahun_ajaran_id;
        $mapping_walikelas = $request->mapping_walikelas_id;
        $kelas = $request->kelas_id;

        foreach ($request->siswa as $siswa_id => $value) {
            $izin = $value['izin'] ?? 0;
            $sakit = $value['sakit'] ?? 0;
            $tanpa_keterangan = $value['tanpa_keterangan'] ?? 0;

            Absen::updateOrCreate(
                [
                    'siswa_id' => $siswa_id,
                    'tahun_ajaran_id' => $tahun_ajaran,
                    'mapping_walikelas_id' => $mapping_walikelas,
                    'kelas_id' => $kelas,
                    'semester' => \App\Models\Semester::where('is_active', true)->first()->kode,
                ],
                [
                    'izin' => $izin,
                    'sakit' => $sakit,
                    'tanpa_keterangan' => $tanpa_keterangan,
                ]
            );
        }


        return redirect()->back()->with('sukses','Absen berhasil disimpan');

    }


}
