<?php

namespace App\Console\Commands;

use App\Models\ListKd;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class PatchingKdAddSemester extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'patching:kd-add-semester';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'One time patching KD to add semester';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        $allListKd = ListKd::all();
        $kdSemester1 = 0;
        $kdSemester2 = 0;
        foreach($allListKd as $kd){
            try {
                DB::beginTransaction();
                if((string) $kd->created_at->format('Y') == '2023'){
                    $kd->semester = 1;
                    $kd->save();
                    $kdSemester1++;
                } else if((string) $kd->created_at->format('Y') == '2024'){
                    $kd->semester = 2;
                    $kd->save();
                    $kdSemester2++;
                }
                DB::commit();
            } catch(\Exception $e){
                DB::rollBack();
                $this->error('Error: '.$e->getMessage());
            }
        }
        $this->info('Patching KD Done!');
        $this->info('KD Semester 1: '.$kdSemester1);
        $this->info('KD Semester 2: '.$kdSemester2);
    }
}
